#!/usr/bin/env python
# coding: utf-8

# # Prädiktion der Bauteilqualität aus Maschinenparametern

# Ziel ist es ein statisches polynomiales Modell zu bestimmen, welches die eingestellen Maschinenparameter auf die resultierende Bauteilqualität abbildet. 
# 
# Die für das Modelltraining (Schätzung der Modellparameter) und die Modellvalidierung zu verwendenden Daten wurden im Rahmen eines umfangreichen Versuchsplanes erhoben. Der Trainingsdatensatz umfasst die Daten von 2105 Produktionszyklen, der Validierungsdatensatz umfasst die Daten von 548 Produktionszyklen

# In[1]:


import casadi as cs
import pickle as pkl
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import seaborn as sns


# In[2]:


data_train = pkl.load(open('setpoint_data_train.pkl','rb'))
data_val= pkl.load(open('setpoint_data_val.pkl','rb'))


# Plotte Ausgangsgröße (Bauteilqualität) des Trainings- und Validierungsdatensatzes

# In[ ]:


fig, ax = plt.subplots(figsize=(20, 10))
sns.stripplot(x=data_train['charge'],y=data_train['Durchmesser_innen'],color='grey',alpha=.8,size=15,ax=ax)
sns.stripplot(x=data_val['charge'],y=data_val['Durchmesser_innen'],size=15,ax=ax)
ax.set_xlim([1,40]) # Zeige nur Teil des Plots da man sonst nicht viel erkennen kann 


# Definiere zu identifizierendes Modell as CasADi-Funktion

# In[3]:


theta0 = cs.MX.sym('theta',1,1)
theta1 = cs.MX.sym('theta',8,1)
theta2 = cs.MX.sym('theta',36,1)

theta = cs.vcat([theta0,theta1,theta2])

u = cs.MX.sym('u',8,1)

interact = cs.mtimes(u,u.T)                       # Erhalte quadratische und Interaktionsterme durch u u'
interact = [interact[i:,i] for i in range(0,8)]   # Wähle obere Dreiecksmatrix
interact = cs.vcat(interact)                      # Forme um in einen Vektor

y = theta0 + cs.mtimes(theta1.T,u) + cs.mtimes(theta2.T,interact)

f_model = cs.Function('f_model',[u,theta],[y],['u','theta'],['y'])


# Werte Modell auf den Trainingsdaten aus und baue die Kostenfunktion auf

# In[4]:


L = 0

u_label=['Düsentemperatur', 'Werkzeugtemperatur', 'Einspritzgeschwindigkeit',
       'Umschaltpunkt', 'Nachdruckhöhe', 'Nachdruckzeit', 'Staudruck',
       'Kühlzeit']

y_label = ['Durchmesser_innen']

for k in data_train.index:
    u_k = data_train.loc[k][u_label].values.reshape((8,1))
    
    y_k = data_train.loc[k][y_label]
    
    y_hat = f_model(u=u_k, theta=theta)['y']
    L = L + 0.5*(y_hat - y_k)**2


# In[5]:





# In[ ]:





# In[ ]:


qp = {'x':theta, 'f':L}
S = cs.qpsol('S', 'qpoases', qp)
r=S()

theta_opt = r['x']


# In[ ]:


y_hat = []

for k in data_train.index:
    u_k = data_train.loc[k][u_label].values.reshape((8,1))
    
    y_k = data_train.loc[k][y_label]
    
    y_hat.append(float(f_model(u=u_k, theta=theta_opt)['y']))
    
data_train = data_train.assign(y_hat=y_hat)


# In[ ]:


y_hat = []

for k in data_val.index:
    u_k = data_val.loc[k][u_label].values.reshape((8,1))
    
    y_k = data_val.loc[k][y_label]
    
    y_hat.append(float(f_model(u=u_k, theta=theta_opt)['y']))
    
data_val = data_val.assign(y_hat=y_hat)


# In[ ]:


fig, ax = plt.subplots(figsize=(20, 10))
sns.stripplot(x=data_train['charge'],y=data_train['Durchmesser_innen'],color='grey',alpha=.8,size=15,ax=ax)
sns.stripplot(x=data_train['charge'],y=data_train['y_hat'],size=15,ax=ax)
ax.set_xlim([1,50]) # Zeige nur Teil des Plots da man sonst nicht viel erkennen kann


# In[ ]:


fig, ax = plt.subplots(figsize=(20, 10))
sns.stripplot(x=data_val['charge'],y=data_val['Durchmesser_innen'],color='grey',alpha=.8,size=15,ax=ax)
sns.stripplot(x=data_val['charge'],y=data_val['y_hat'],size=15,ax=ax)
ax.set_xlim([1,50]) # Zeige nur Teil des Plots da man sonst nicht viel erkennen kann


# In[ ]:




